#ifndef __CTimeSignature__
#define __CTimeSignature__

#include <Basics/CCountedObject.hpp>
using Exponent::Basics::CCountedObject;

//	===========================================================================

namespace Exponent
{
	namespace Music
	{
		/**
		 * @class CTimeSignature CTimeSignature.hpp
		 * @brief A representation of a time signature
		 *
		 * @date 30/12/2004
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CTimeSignature.hpp,v 1.3 2007/02/08 21:08:09 paul Exp $
		 */
		class CTimeSignature : public CCountedObject
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

			/**
			 * Construction
			 * @param numerator The numerator
			 * @param denominator The denominator
			 */
			CTimeSignature(const long numerator = 4, const long denominator = 4);

			/**
			 * Copy construction
			 * @param timeSig The time signature to copy
			 */
			CTimeSignature(const CTimeSignature &timeSig);

			/**
			 * Destruction
			 */
			virtual ~CTimeSignature();

//	===========================================================================

			/**
			 * Assignment operator
			 * @param timeSig The time signature to copy
			 */
			CTimeSignature &operator = (const CTimeSignature &timeSig);

//	===========================================================================

			/**
			 * Set the time signature
			 * @param numerator The numerator
			 * @param denominator The denominator
			 */
			void setTimeSignature(const long numerator, const long denominator);

			/**
			 * Set numerator
			 * @param numerator The numerator
			 */
			void setNumerator(const long numerator);

			/**
			 * Set denominator
			 * @param denominator The denominator
			 */
			void setDenominator(const long denominator);

//	===========================================================================

			/**
			 * Get the denominator
			 * @retval long The denominator
			 */
			long getDenominator() const;

			/**
			 * Get the numerator
			 * @retval long The numerator
			 */
			long getNumerator() const;

//	===========================================================================

			/**
			 * Get as double ranged value
			 * @retval double numerator / denominator
			 */
			double getAsDecimal() const;

//	===========================================================================

		protected:

//	===========================================================================

			long m_numerator;		/**< The numerator */
			long m_denominator;		/**< The denominator */
		};
	}
}
#endif	// End of CTimeSignature.hpp